﻿/*
VERSION:	2.5
	2.5		Added "mask_mc" for legacy support
	2.4		Added "extra features"
	2.3		Encapsulated into a newSprite() function
	2.2		Added interface properties, methods, and events  (missing: extra features)
	2.1		Missing interface properties, methods, and events
	
NOTE:
	This is sprite system 4.
	It has been completely re-written from scratch to use BitmapData instead of masking

EVENTS
	animDone			Broadcast after a "once" animation displays its last frame
	
DESCRIPTION:
	Pros:		Performance.  Able to send BitmapData as a charset input.  (sprite system clones it)
	Cons:		Cannot load SWF files as charsets
	
NOTE:
	This sprite system places the character's feet at the origin point.	(Feet:  1/2 image width, full image height)
	
	
USAGE:
	#include "functions/sprite.as"
	newSprite();			// minimum usage		(nothing is seen, but it can be modified later)
	
	
	#include "functions/sprite.as"
	var settings = {
		charset				:	"charset/marle.png",
		direction			:	2,				//(base zero)
		directions		:	4,				//(base one)		(amount of directions)
		frame					:	1,				//(base zero)
		frames				:	3,				//(base one)		(amount of frames)
		pose					:	0,				//(base zero)
		columns				:	4,				//(base zero)
		rows					:	2,				//(base zero)
		animType			:	"yoyo",
		animDirection	:	1,
		delay					:	3,				//(base one)
		isAnimating		:	true
	}
	mySprite = newSprite( [settings], [parent], [instanceName], [depth] );			// maximum usage		(rm2k settings)
	
	mySprite.setParams({isAnimating:true});
	
	spriteState = mySprite.getParams();
	
	direction = mySprite.getParam( "direction" );
	
	
EXTRA FEATURES:
	// Compares the PARENT movieClip's coords to the x,y passed to this function as parameters
	// This sprite must be wrapped within a movieClip. That movieClip's coords are then compared to the ones specified
	sprite.lookAtCoords( x, y );
	
	// make this sprite look at the specified movieClip.  (The specified movieClip must be a sibling of this sprite's parent)
	// This sprite must be wrapped within a movieClip. That movieClip's coords are then compared to specified movieClip
	sprite.lookAtSprite( movieClip );
	
	// DEPRECATED:		This makes the specified sprite1 look at the specified movieClip2.  (The specified movieClip must be a sibling of this sprite's parent)
	// The specified sprite1 must be wrapped within a movieClip. That movieClip's coords are then compared to specified movieClip2
	sprite.lookAt( sprite1, movieClip2 );
	
	// Report whether or not this sprite is facing in the specified direction
	// Directions can be specified either as numbers or strings:   "up" "right" "down" "left"
	_this.isFacing = function( checkDir )
	
	
	
DEFAULT SETTINGS:
	You can skip most settings when you setup a sprite.
	When you do, it defaults to these values:
		charset				:	""		(can be set later)
		direction			:	0
		directions		:	1
		frame					:	0
		frames				:	1
		pose					:	0
		columns				:	1
		rows					:	1
		animType			:	"loop"
		animDirection	:	1
		delay					:	4
		isAnimating		:	true
	
DEPENDANCIES:
	nextDepth.as

EVENTS:
	animDone			Broadcast after an animation completes or loops

DEPTHS:
	0		loader_mc
	1		image_mc
	2		mask_mc

INTERNAL VARIABLES
	var _this, internal, spriteWidth, spriteHeight, image_mc, image_pic, loader_mc, charset_pic, delayCounter, copy, paste;
INTERNAL FUNCTIONS
	var loadNewCharset, setSpriteSize, update, advanceFrame, onTimer, loop, onEnterFrame;

*/
import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;



function newSprite( newSettings, newTarget, newName, newDepth )
{
	// resolve movieClip parameters
	// target
	var newTarget = (newTarget) ? newTarget : this;
	// name
	var newName = (newName) ? newName : "sprite_"+Math.floor(Math.random()*9999);
	while(newTarget[newName]){
		var newName = "sprite_"+Math.floor(Math.random()*9999);
	}// while:  this movieClip already exists
	// depth
	#include "nextDepth.as"
	var newDepth = (newDepth!=undefined) ? newDepth : nextDepth(newTarget);
	
	
	// create movieClip
	var _this = newTarget.createEmptyMovieClip( newName, newDepth );
	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////
	// initialize variables
	_this.internal = {
		charset:"",
		direction:0,
		directions:1,
		frame:0,
		frames:1,
		pose:0,
		columns:1,
		rows:1,
		animType:"loop",
		animDirection:1,
		delay:4,
		isAnimating:true
	}// {internal}
	//for(var nam in newSettings)
	//	_this.internal[nam] = newSettings[nam];
	//
	_this.copy = new Rectangle(0,0, 16, 16);
	_this.paste = new Point(0,0);
	_this.delayCounter = 0;
	
	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////
	// define functions
	_this.loadNewCharset = function( file, callback ){
		var success = false;
		
		// references the specified bitmapData object as charset_pic
		var copyBitmap = function( new_pic ){
			_this.charset_pic.dispose();
			_this.charset_pic = new_pic;
			_this.setSpriteSize();
			callback( _this.charset_pic );
		}// copyBitmap()
		
		// takes a snapshot of loader_mc and stores it as charset_pic
		var copyMovieClip = function(){
			_this.charset_pic.dispose();
			_this.charset_pic = new BitmapData( _this.loader_mc._width, _this.loader_mc._height, true, 0 );
			_this.charset_pic.draw( _this.loader_mc );
			_this.loader_mc.removeMovieClip();
			_this.setSpriteSize();
			callback( _this.charset_pic );
		}// copyMovieClip()
		
		
		// try direct bitmapData obejct
		if(file.generateFilterRect != undefined){
			copyBitmap( file.clone() );
			return;
		}// if:  input IS a bitmap
		
		// try internal bitmap
		var new_bitmap = BitmapData.loadBitmap( file );
		success = Boolean(new_bitmap.width > 0);
		if(success){
			copyBitmap( new_bitmap );
			return;
		}// if:  success
		
		// try internal movieClip
		_this.loader_mc = _this.attachMovie( file, "loader_mc", 0 );
		success = Boolean(_this.loader_mc != undefined);
		if(success){
			copyMovieClip();
			return;
		}// if:  success
		
		// try external file
		_this.loader_mc = _this.createEmptyMovieClip("loader_mc", 0);
		var loader = new MovieClipLoader();
		loader.onLoadComplete = function(){
			_this.loader_mc._visible = false;
		}// onLoadComplete()
		loader.onLoadInit = function(){
			copyMovieClip();
			return;
		}// onLoadInit()
		loader.loadClip( file, _this.loader_mc );
	}// loadNewCharset()
	
	
	_this.setSpriteSize = function(){
		var old_spriteWidth = _this.spriteWidth;
		var old_spriteHeight = _this.spriteHeight;
		_this.spriteWidth = Math.floor(_this.charset_pic.width / _this.internal.columns / _this.internal.frames);
		_this.spriteHeight = Math.floor(_this.charset_pic.height / _this.internal.rows / _this.internal.directions);
		if(	old_spriteWidth != _this.spriteWidth
		||	old_spriteHeight != _this.spriteHeight){
			_this.image_pic.dispose();
			_this.image_pic = new BitmapData( _this.spriteWidth, _this.spriteHeight, true, 0 );
			_this.image_mc = _this.createEmptyMovieClip("image_mc", 1);
			_this.image_mc.attachBitmap( _this.image_pic, 0 );
			// stand on top of the origin
			_this.image_mc._x = -_this.spriteWidth / 2;
			_this.image_mc._y = -_this.spriteHeight;
			//
			_this.copy.width = _this.spriteWidth;
			_this.copy.height = _this.spriteHeight;
			_this.update();		// redraw immediately to avoid flicker
			
			// legacy mask
			_this.updateMask();
		}// if:  sprite size changes
	}// setSpriteSize()
	
	
	// copy from charset_pic -> image_pic
	_this.update = function(){
		var xPoseIndex = _this.internal.pose %_this.internal.columns;
		var poseWidth = _this.spriteWidth *_this.internal.frames;
		var xPoseOffset = xPoseIndex *poseWidth;
		var frameOffset = _this.internal.frame *_this.spriteWidth;
		_this.copy.x = xPoseOffset + frameOffset;
		var yPoseIndex = Math.floor(_this.internal.pose /_this.internal.columns);
		var poseHeight = _this.spriteHeight *_this.internal.directions;
		var yPoseOffset = yPoseIndex *poseHeight;
		var directionOffset = _this.internal.direction *_this.spriteHeight;
		_this.copy.y = yPoseOffset + directionOffset;
		_this.image_pic.copyPixels( _this.charset_pic, _this.copy, _this.paste );
	}// update()
	
	
	_this.advanceFrame = function(){
		_this.internal.frame += _this.internal.animDirection;
		
		// yoyo
		if(_this.internal.animType == 'yoyo'){
			if(_this.internal.frame >= _this.internal.frames){
				_this.internal.frame = _this.internal.frames-1;
				_this.internal.animDirection *= -1;
				_this.internal.frame += _this.internal.animDirection;
				_this.broadcastMessage("animDone");
				_this.animDone();
			}else if(_this.internal.frame <= -1){
				_this.internal.frame = 0;
				_this.internal.animDirection *= -1;
				_this.internal.frame += _this.internal.animDirection;
				_this.broadcastMessage("animDone");
				_this.animDone();
			}
		}// if:  yoyo
		
		// loop
		else if(_this.internal.animType == 'loop'){
			var oldFrame = _this.internal.frame;
			
			// loop relative to how far the max frames were exceeded
			// loop beyond minimum
			while(_this.internal.frame < 0)
				_this.internal.frame += _this.internal.frames;
			// loop beyond maximum
			_this.internal.frame %= _this.internal.frames;
			
			if(oldFrame >= _this.internal.frames){
				//_this.internal.frame = 0;
				_this.broadcastMessage("animDone");
				_this.animDone();
			}else if(oldFrame <= -1){
				//_this.internal.frame = _this.internal.frames-1;
				_this.broadcastMessage("animDone");
				_this.animDone();
			}
		}// if:  loop
		
		// once
		else if(_this.internal.animType == 'once'){
			if(_this.internal.frame >= _this.internal.frames){
				_this.internal.frame = _this.internal.frames-1;
				_this.internal.isAnimating = false;
				_this.broadcastMessage("animDone");
				_this.animDone();
			}else if(_this.internal.frame <= -1){
				_this.internal.frame = 0;
				_this.internal.isAnimating = false;
				_this.broadcastMessage("animDone");
				_this.animDone();
			}
		}// if:  once
	}// advanceFrame()
	
	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////
	// Interface
	_this.getParams = function(){
		var output = {};
		for(var nam in _this.internal)
			output[nam] = _this.internal[nam];
		return output;
	}// getParams()
	
	
	_this.getParam = function( nam ){
		return _this.internal[nam];
	}// getParam()
	
	
	_this.setParams = function( new_settings ){
		var adjustDirection = function(){
			var incr = _this.internal.directions/4;
			if(_this.internal.direction.toLowerCase()=="up"){
				_this.internal.direction = 0;
			}else if(_this.internal.direction.toLowerCase()=="right"){
				_this.internal.direction = Math.floor(1*incr);
			}else if(_this.internal.direction.toLowerCase()=="down"){
				_this.internal.direction = Math.floor(2*incr);
			}else if(_this.internal.direction.toLowerCase()=="left"){
				_this.internal.direction = Math.floor(3*incr);
			}
			// loop relative to how far the bounds were exceeded
			// limit minimum to looping range
			while(_this.internal.direction < 0)
				_this.internal += _this.internal.directions;
			// loop the maximum
			_this.internal.direction %= _this.internal.directions;
		}// adjustDirection()
		
		var adjustFrame = function(){
			// adjust frames
			if(_this.internal.frame >= _this.internal.frames){
				if(_this.internal.frames >= 3){
					// 3 or more frames
					_this.internal.frame = 1;
				}else{
					// 1 or 2 frames
					_this.internal.frame = 0;
				}
			}// if:  old frame is now out-of-bounds
		}// adjustFrame()
		
		var adjustDelay = function(){
			if(_this.internal.delay <= 0)
				_this.internal.delay = 0.1;
		}// adjustDelay()
		
		
		var applyOtherSettings = function(){
			// copy settings
			for(var nam in new_settings)
				_this.internal[nam] = new_settings[nam];
			
			adjustDirection();
			adjustFrame();
			adjustDelay();
			
			// immediately redraw
			_this.setSpriteSize();
			_this.update();
		}// applyOtherSettings()
		
		
		if(new_settings.charset){
			_this.loadNewCharset( new_settings.charset, function(){
				applyOtherSettings();
			} );// after loading charset
		}
		else{
			applyOtherSettings();
		}
	}// setParams()
	
	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////
	// EXTRA FEATURES
	// The sprite needs to be inside of a movieClip for this to work
	// Compares the parent movieClip's coords to the x,y passed to this function as parameters
	_this.lookAtCoords = function()
	{
		var destX = arguments[0];
		var destY = arguments[1];
		// get a unit vector
		var xDiff = destX - _this._parent._x;
		var yDiff = destY - _this._parent._y;
		
		// compare x & y
		if( Math.abs(yDiff) > Math.abs(xDiff) )
		{
			// vert
			if( yDiff < 0)
			{
				// up
				_this.setParams( {direction:"up"} );
			}else{
				// down
				_this.setParams( {direction:"down"} );
			}// if:  up or down
		}else{
			// horz
			if( xDiff < 0 )
			{
				// left
				_this.setParams( {direction:"left"} );
			}else{
				// right
				_this.setParams( {direction:"right"} );
			}// if:  left or right
		}// if:  vert or horz
	}// lookAtCoords()
	
	
	// make this sprite look at the specified movieClip.  (The specified movieClip must be a sibling of this sprite's parent)
	_this.lookAtSprite = function( clip2 ){
		_this.lookAtCoords( clip2._x, clip2._y );
	}// lookAtSprite()
	
	
	/*
	// DEPRECATED:		This makes the specified sprite look at the specified movieClip.  (The specified movieClip must be a sibling of this sprite's parent)
	_this.lookAt = function( sprite1, clip2 ){
		sprite1.lookAtSprite( clip2 );
	}// lookAt()
	*/
	_this.lookAt = function( sprite1, sprite2 )
	{
		// get a unit vector
		var xDiff = sprite2._x - sprite1._x;
		var yDiff = sprite2._y - sprite1._y;
		var dist = Math.sqrt( xDiff*xDiff + yDiff*yDiff );
		var xUnit = xDiff / dist;
		var yUnit = yDiff / dist;
		
		// compare x & y
		if( Math.abs(yUnit) > Math.abs(xUnit) )
		{
			// vert
			if( yUnit < 0)
			{
				// up
				_this.setParams( {direction:"up"} );
			}else{
				// down
				_this.setParams( {direction:"down"} );
			}// if:  up or down
		}else{
			// horz
			if( xUnit < 0 )
			{
				// left
				_this.setParams( {direction:"left"} );
			}else{
				// right
				_this.setParams( {direction:"right"} );
			}// if:  left or right
		}// if:  vert or horz
	}// lookAt()
	
	
	
	// report whether or not this sprite is facing in the specified direction
	_this.isFacing = function( checkDir )
	{
		var incr = _this.internal.directions/4;
		if(checkDir.toLowerCase()=="up"){
			var checkDir = 0;
		}else if(checkDir.toLowerCase()=="right"){
			var checkDir = Math.floor(1*incr);
		}else if(checkDir.toLowerCase()=="down"){
			var checkDir = Math.floor(2*incr);
		}else if(checkDir.toLowerCase()=="left"){
			var checkDir = Math.floor(3*incr);
		}
		// limit minimum to looping range
		while(checkDir < 0)
			checkDir += _this.internal.directions;
		// loop the maximum
		checkDir %= _this.internal.directions;
		return (_this.internal.direction == checkDir);
	}// isFacing()
	
	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////
	// Legacy features
	_this.set_charset = function( new_charset, newThis, callback ){
		_this.loadNewCharset( new_charset, callback );
	}// set_charset()
	
	
	// create mask
	_this.mask_mc = _this.createEmptyMovieClip( "mask_mc", 2 );
	_this.mask_mc.beginFill(0xff0000, 0);
	_this.mask_mc.lineTo(16,0);
	_this.mask_mc.lineTo(16,16);
	_this.mask_mc.lineTo(0,16);
	_this.mask_mc.lineTo(0,0);
	_this.mask_mc.endFill();
	_this.updateMask = function(){
		// size
		_this.mask_mc._width = _this.spriteWidth;
		_this.mask_mc._height = _this.spriteHeight;
		// position
		_this.mask_mc._x = -_this.spriteWidth / 2;
		_this.mask_mc._y = -_this.spriteHeight;
	}// updateMask();
	
	
	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////
	// LOOP
	_this.fps = 30;
	_this.loop = function(){
		if(_this.internal.isAnimating){
			_this.advanceFrame();
			_this.update();
		}// isAnimating()
		_this.loopInterval = setTimeout( _this.loop, 1000/_this.fps*_this.internal.delay );
	}// loop()
	_this.loop();
	
	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////
	// initial setup
	AsBroadcaster.initialize( _this );		// enable events
	//_this.loadNewCharset( _this.internal.charset );
	_this.setParams( newSettings );
	
	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////
	// clean-up
	_this.onUnload = function(){
		if(_this.loopInterval!=undefined)
			clearTimeout( _this.loopInterval );
		// clear events
		for(var i in _this._listeners)
			_this._listeners[i] = null;
		_this._listeners = [];
	}// onUnload()

	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////
	return _this;
}// newSprite()
